package ie.ucd.sixth.adaptor.davis;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;

import ie.ucd.sixth.core.adaptor.SensorMessageTranslationException;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import ie.ucd.sixth.core.sensor.data.Modality;
import ie.ucd.sixth.core.sensor.data.SensorData;

public class DavisMessageTranslator {

	public DavisMessageTranslator() {

	}

	public SensorData translateMessage(byte[] buffertest)
			throws SensorMessageTranslationException {
		// TODO Auto-generated method stub
		// List<ISensorData> list = new Vector<ISensorData>();

		String barometer = null, tempInside, tempOutside, humInside, humOutside, windSpeed, windDir, windSpeed10min, rain, uv, solar, storm, dayRain, monthRain, yearRain, sunrise, sunset, battery;
		int nodeID = 0;

		if (buffertest != null) {

			// String weatherData = new String(buffertest,0,lentest,"UTF-8");
			// System.out.print(weatherData);
			if (((char) buffertest[0] == 'L') && ((char) buffertest[1] == 'O')
					&& ((char) buffertest[2] == 'O'))

				nodeID = 1;

			barometer = ((int) (buffertest[7] << 8 | (buffertest[8] & 0xFF)))
					/ 1000 + "Hg";
			tempInside = ((float) (buffertest[10] << 8 | (buffertest[9] & 0xFF)))
					/ 10 + "F";
			humInside = (int) buffertest[11] + "%";
			tempOutside = ((float) (buffertest[13] << 8 | (buffertest[12] & 0xFF)))
					/ 10 + "F";
			windSpeed = (short) buffertest[14] + "mph";
			windSpeed10min = (short) buffertest[15] + "mph/10min";
			windDir = (int) (buffertest[17] << 8 | (buffertest[16] & 0xFF))
					+ "\u00b0";
			humOutside = (int) buffertest[33] + "%";
			rain = ((float) (buffertest[42] << 8 | (buffertest[41] & 0xFF)))
					/ 100 + "in/h";
			uv = (int) buffertest[43] + "UV";
			solar = (int) (buffertest[45] << 8 | (buffertest[44] & 0xFF))
					+ "watt/m2";
			storm = (int) (buffertest[47] << 8 | (buffertest[46] & 0xFF))
					+ "in";
			dayRain = (float) (buffertest[51] << 8 | (buffertest[50] & 0xFF))
					+ "in";
			monthRain = (float) (buffertest[53] << 8 | (buffertest[52] & 0xFF))
					+ "in";
			yearRain = (float) (buffertest[55] << 8 | (buffertest[54] & 0xFF))
					+ "in";
			sunrise = (int) (buffertest[92] << 8 | (buffertest[91] & 0xFF))
					+ "AM";
			sunset = (int) (buffertest[94] << 8 | (buffertest[95] & 0xFF))
					+ "PM";
			battery = ((((float) (buffertest[88] << 8 | (buffertest[87] & 0xFF))) * 300) / 512)
					/ 100 + "%";

			HashMap<Modality, String> valueMaps = new HashMap<Modality, String>();
			valueMaps.put(Modality.Barometer, barometer);
			valueMaps.put(Modality.TempInside, tempInside);
			valueMaps.put(Modality.HumInside, humInside);
			valueMaps.put(Modality.TempOutside, tempOutside);
			valueMaps.put(Modality.WindSpeed, windSpeed);
			valueMaps.put(Modality.WindSpeed10min, windSpeed10min);
			valueMaps.put(Modality.WindDir, windDir);
			valueMaps.put(Modality.HumOutside, humOutside);
			valueMaps.put(Modality.Rain, rain);
			valueMaps.put(Modality.UV, uv);
			valueMaps.put(Modality.SolarRad, solar);
			valueMaps.put(Modality.Storm, storm);
			valueMaps.put(Modality.dayRain, dayRain);
			valueMaps.put(Modality.monthRain, monthRain);
			valueMaps.put(Modality.yearRain, yearRain);
			valueMaps.put(Modality.sunRise, sunrise);
			valueMaps.put(Modality.sunSet, sunset);
			valueMaps.put(Modality.Battery, battery);

			SensorData data = new SensorData("DavisWeather", nodeID,
					new Modality("Davis"), valueMaps, ISensorData.TYPE_PERIODIC);

			/*
			System.out.println(data.getValue(Modality.Barometer) + " , "
					+ data.getValue(Modality.TempInside) + " , "
					+ data.getValue(Modality.HumInside) + " , "
					+ data.getValue(Modality.TempOutside) + " , "
					+ data.getValue(Modality.WindSpeed) + " , "
					+ data.getValue(Modality.WindSpeed10min) + " , "
					+ data.getValue(Modality.WindDir) + " , "
					+ data.getValue(Modality.HumOutside) + " , "
					+ data.getValue(Modality.Rain) + " , "
					+ data.getValue(Modality.UV) + " , "
					+ data.getValue(Modality.SolarRad) + " , "
					+ data.getValue(Modality.Storm) + " , "
					+ data.getValue(Modality.dayRain) + " , "
					+ data.getValue(Modality.monthRain) + " , "
					+ data.getValue(Modality.yearRain) + " , "
					+ data.getValue(Modality.sunRise) + " , "
					+ data.getValue(Modality.sunSet) + " , "
					+ data.getValue(Modality.Battery));
              */

			return data;

			/*
			 * System.out.println((char)buffertest[0] + " "+
			 * (char)buffertest[1]+ " "+ (char)buffertest[2] + " " +
			 * (int)buffertest[3] + " " + (int)buffertest[4] + " "+
			 * (int)(buffertest[5] << 8 | (buffertest[6] & 0xFF)) + " "+
			 * ((int)(buffertest[7] << 8 | (buffertest[8] & 0xFF)))/1000 +
			 * "barometer" + " "+ ((float)(buffertest[10] << 8 | (buffertest[9]
			 * & 0xFF)))/10 + "F(in)" + " " + (int)buffertest[11]+"%" + " "+
			 * ((float)(buffertest[13] << 8 | (buffertest[12] & 0xFF)))/10 +
			 * "F(out)" + " " + (short)buffertest[14]+"mph" + " " +
			 * (short)buffertest[15]+"mph-10min" + " "+ (int)(buffertest[17] <<
			 * 8 | (buffertest[16] & 0xFF))+ "\u00b0" + " (" +
			 * (int)buffertest[18] + " " + (int)buffertest[19] + " " +
			 * (int)buffertest[20] + " " + (int)buffertest[21] + " " +
			 * (int)buffertest[22] + " " + (int)buffertest[23] + " " +
			 * (int)buffertest[24] + ")F(Extra)" + " (" + (int)buffertest[25] +
			 * " " + (int)buffertest[26] + " " + (int)buffertest[27] + " " +
			 * (int)buffertest[28] + ")F(soil)" + " (" + (int)buffertest[29] +
			 * " " + (int)buffertest[30] + " " + (int)buffertest[31] + " " +
			 * (int)buffertest[32] + ")F(leaf)" + " " + (int)buffertest[33] +"%"
			 * + " (" + (int)buffertest[34] + " " + (int)buffertest[35] + " " +
			 * (int)buffertest[36] + " " + (int)buffertest[37] + " " +
			 * (int)buffertest[38] + " " + (int)buffertest[39] + " " +
			 * (int)buffertest[40] + ")%(Extra)" + " "+ ((float)(buffertest[42]
			 * << 8 | (buffertest[41] & 0xFF)))/100 + "in/h" + " " +
			 * (int)buffertest[43] + "UV" + " " + (int)(buffertest[44] << 8 |
			 * (buffertest[45] & 0xFF)) + "watt/m2" + " " + (int)(buffertest[46]
			 * << 8 | (buffertest[47] & 0xFF)) + "in" //+ " " +
			 * (int)((buffertest[48] >>> 4) | 0x0F)
			 * 
			 * + " " + (float)(buffertest[50] << 8 | (buffertest[51] & 0xFF)) +
			 * "in(day)" + " " + (float)(buffertest[52] << 8 | (buffertest[53] &
			 * 0xFF)) + "in(mon)" + " " + (float)(buffertest[54] << 8 |
			 * (buffertest[55] & 0xFF)) + "in(year)" + " " +
			 * (float)(buffertest[56] << 8 | (buffertest[57] & 0xFF)) + "in" +
			 * " " + (float)(buffertest[58] << 8 | (buffertest[59] & 0xFF)) +
			 * "in" + " " + (float)(buffertest[60] << 8 | (buffertest[61] &
			 * 0xFF)) + "in" //+ " " + (float)(buffertest[62] << 8 |
			 * buffertest[62] << 16 |buffertest[63] << 24 |(buffertest[61] &
			 * 0xFF)) + " " + ((((float)(buffertest[87] << 8 | (buffertest[88] &
			 * 0xFF)))*300)/512)/100 + "%" + " " + (int)(buffertest[92] << 8 |
			 * (buffertest[91] & 0xFF)) + "Sunrise" + " " + (int)(buffertest[94]
			 * << 8 | (buffertest[93] & 0xFF)) + "Sunset" );
			 */

		}
		return null;
	}
}
